/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.model;

import com.badlogic.gdx.graphics.Color;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.mapgen.model.RockGroup;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GameMaterial {
    private final String materialName;
    private long materialId;
    private final GameMaterialType materialType;
    private final String colorCode;
    @JsonIgnore
    private final Color color;
    private final Boolean isMetallic;
    private final RockGroup rockGroup;
    private final Float prevalence;
    private final List<String> oreNames;

    public GameMaterial(String materialName, long materialId, GameMaterialType type) {
        this(materialName, materialId, type, null, null, null, null, null);
    }

    @JsonCreator
    public GameMaterial(@JsonProperty(value="materialName") String materialName, @JsonProperty(value="materialId") long materialId, @JsonProperty(value="materialType") GameMaterialType materialType, @JsonProperty(value="colorCode") String colorCode, @JsonProperty(value="rockGroup") RockGroup rockGroup, @JsonProperty(value="prevalence") Float prevalence, @JsonProperty(value="oreNames") List<String> oreNames, @JsonProperty(value="isMetallic") Boolean isMetallic) {
        this.materialName = materialName;
        this.materialId = materialId;
        this.colorCode = colorCode;
        this.rockGroup = rockGroup;
        this.prevalence = prevalence;
        this.oreNames = oreNames;
        this.isMetallic = isMetallic;
        this.materialType = materialType != null ? materialType : GameMaterialType.OTHER;
        if (colorCode == null) {
            this.color = null;
        } else if (colorCode.length() == 7) {
            this.color = new Color((float)Integer.parseInt(colorCode.substring(1, 3), 16) / 255.0f, (float)Integer.parseInt(colorCode.substring(3, 5), 16) / 255.0f, (float)Integer.parseInt(colorCode.substring(5, 7), 16) / 255.0f, 1.0f);
        } else {
            this.color = null;
            System.err.println("Unrecognised color code " + colorCode + " for GameMaterial " + this.materialName);
        }
    }

    public void setMaterialId(long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return this.materialName;
    }

    public long getMaterialId() {
        return this.materialId;
    }

    public GameMaterialType getMaterialType() {
        return this.materialType;
    }

    public RockGroup getRockGroup() {
        return this.rockGroup;
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public Color getColor() {
        return this.color;
    }

    public Float getPrevalence() {
        return this.prevalence;
    }

    public List<String> getOreNames() {
        return this.oreNames;
    }

    public Boolean getIsMetallic() {
        return this.isMetallic;
    }

    public String getI18nKey() {
        return this.materialType.name() + "." + this.materialName.toUpperCase().replaceAll(" ", "_");
    }

    public String toString() {
        return this.materialName + "(" + this.materialType.name() + ")";
    }

    @JsonIgnore
    public boolean isMetallic() {
        if (this.isMetallic == null) {
            return false;
        }
        return this.isMetallic;
    }
}

